import React, { useState } from "react";
import Form from "@rjsf/core";
import validator from "@rjsf/validator-ajv8";

// JSON schema for Pricing Rules Form
export const userSchema = {
  title: "Service Form",
  description: "Create or update Service.",
  type: "object",
  required: [
    "service_title",
    "service_description",
    "capacity_jobs",
    "has_cost",
    "is_vehicle_focused",
    "image",
    "map_icon",
  ],
  properties: {
    service_title: {
      type: "string",
      title: "Service Name",
    },
    service_description: {
      type: "string",
      title: "Service Description",
    },
    capacity_jobs: {
      type: "number",
      title: "Capacity",
    },
    has_cost: {
      type: "number", // Change to enum with 1 and 0 for radio
      title: "Has Cost",
      enum: [1, 0],
      enumNames: ["Yes", "No"],
    },
    is_vehicle_focused: {
      type: "number", // Change to enum with 1 and 0 for radio
      title: "Is Vehicle Focused",
      enum: [1, 0],
      enumNames: ["Yes", "No"],
    },
    image: {
      type: "string",
      format: "data-url",
      title: "Image Upload",
    },
    map_icon: {
      type: "string",
      format: "data-url",
      title: "Map Icon Upload",
    },
    user_id: {
      type: "string", // Use string or number based on your DB
      title: "User ID",
      default: "{id}",
    },
    account_id: {
      type: "string", // Use string or number based on your DB
      title: "User ID",
      default: "{id}",
    },
  },
};

// Optional UI schema tweaks
export const userUiSchema = {
  image: {
    "ui:widget": "file", // File upload for images
  },
  map_icon: {
    "ui:widget": "file", // File upload for map icons
  },
  is_vehicle_focused: {
    "ui:widget": "radio", // Set as radio button
  },
  has_cost: {
    "ui:widget": "radio", // Set as radio button
  },
  user_id: {
    "ui:widget": "hidden", // Hide user_id field
  },
  account_id: {
    "ui:widget": "hidden", // Hide user_id field
  },
};

const UserForm = ({ initialData, onSubmit }) => {
  const [formData, setFormData] = useState(initialData || {});

  const handleSubmit = ({ formData }) => {
    console.log("Form Submitted:", formData);
    onSubmit(formData);
  };

  return (
    <div style={{ maxWidth: "600px", margin: "0 auto" }}>
      <Form
        schema={userSchema}
        uiSchema={userUiSchema}
        formData={formData}
        onChange={({ formData }) => setFormData(formData)}
        onSubmit={handleSubmit}
        validator={validator}
        liveValidate
      />
    </div>
  );
};

export default UserForm;
